var manageTeacherTable;
var base_url = $("#base_url").val();

$(document).ready(function() {
	$("#topReportMainNav").addClass('active');

	manageTeacherTable = $("#manageTeacherTable").DataTable({
		'ajax' : base_url + 'teacher/fetchTeacherData',
		'order' : []
	});

	/*
	*-------------------------------------------------
	* click on the add teacher model button
	*-------------------------------------------------
	*/
	$("#addTeacherModelBtn").unbind('click').bind('click', function() {
		$('#registerDate').calendarsPicker({
			dateFormat: 'yyyy-mm-dd'
		});
		
		$('#dob').calendarsPicker({
			dateFormat: 'yyyy-mm-dd'
		});

		/*remove error messages*/
		$(".form-group").removeClass('has-success').removeClass('has-error');
		$(".text-danger").remove();
		$("#add-teacher-messages").html('');

		$("#createTeacherForm").unbind('submit').bind('submit', function() {
			var form = $(this);
			var formData = new FormData($(this)[0]);
			var url = form.attr('action');
			var type = form.attr('method');

			$.ajax({
				url : url,
				type : type,
				data: formData,
				dataType: 'json',
				cache: false,
				contentType: false,
				processData: false,
				async: false,
				success:function(response) {					

					if(response.success == true) {						
						$("#add-teacher-messages").html('<div class="alert alert-success alert-dismissible" role="alert">'+
						  '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>'+
						  response.messages + 
						'</div>');		

						manageTeacherTable.ajax.reload(null, false);
						$('.form-group').removeClass('has-error').removeClass('has-success');
						$('.text-danger').remove();
						clearForm();
					}	
					else {									
						if(response.messages instanceof Object) {							
							$.each(response.messages, function(index, value) {
								var key = $("#" + index);

								key.closest('.form-group')
								.removeClass('has-error')
								.removeClass('has-success')
								.addClass(value.length > 0 ? 'has-error' : 'has-success')
								.find('.text-danger').remove();							

								key.after(value);

							});
						}
						else {							
							$("#add-teacher-messages").html('<div class="alert alert-warning alert-dismissible" role="alert">'+
							  '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>'+
							  response.messages + 
							'</div>');						
						}							
					} // /else
				} // /success
			}); // /ajax

			return false;
		});	
	}); // /click on the add teacher button

	
});

/*
*-------------------------------------------------
* clears the form 
*-------------------------------------------------
*/
function clearForm()
{
	$('input[type="text"]').val('');
	$('select').val('');
	$(".fileinput-remove-button").click();	
}