<?php 

class Model_Report extends CI_Model 
{
	public function __construct()
	{
		parent::__construct();
	}

	/*
	*------------------------------------
	* inserts the student's information
	* into the database 
	*------------------------------------
	*/
	
	/*
	*-----------------------------------
	* fetches the EXPENSES
	*-----------------------------------
	*/
	public function fetchExpenseReport($date_from = NULL, $date_to = NULL)
	{

			$sql = "SELECT *, sum(total_amount) as total from expenses_name 
					WHERE date between '$date_from' AND '$date_to' 
					GROUP BY id desc, date desc 
					LIMIT 50";
			$query = $this->db->query($sql);
			return $query->result_array();

	}
	
		
	/*
	*-----------------------------------
	* fetches the INCOME BY DATE
	*-----------------------------------
	*/
	public function fetchIncomeReport($date_from = NULL, $date_to = NULL)
	{

			$sql = "SELECT *, sum(paid_amount) as total, concat(`fname`, ' ' , `lname`) as `student` from payment_history
					JOIN student ON student.student_id = payment_history.student_id
					JOIN payment_name ON payment_name.id = payment_history.payment_name_id 
					WHERE payment_date between '$date_from' AND '$date_to' 
					GROUP BY payment_name_id desc, payment_date desc
					LIMIT 50";
			$query = $this->db->query($sql);
			return $query->result_array();

	}
	
	/*
	*-----------------------------------
	* fetches the INCOME BY STUDENT
	*-----------------------------------
	*/
	public function fetchIncomeStudentReport($date_from = NULL, $date_to = NULL, $student_id = NULL, $summary = NULL)
	{
		if($summary == 'FALSE') {
			$sql = "SELECT *, sum(paying_amount) as total, concat(`fname`, ' ' , `lname`) as `student` from payment_history
					JOIN student ON student.student_id = payment_history.student_id
					JOIN payment_name ON payment_name.id = payment_history.payment_name_id 
					WHERE payment_date between '$date_from' AND '$date_to' AND payment_history.student_id = '$student_id'
					GROUP BY payment_history.history_id desc, payment_name_id desc
					ORDER BY payment_date desc
					LIMIT 50"; 
			$query = $this->db->query($sql);
			return $query->result_array();
			
		} else if($summary == 'TRUE') {
			$sql = "SELECT *, sum(paying_amount) as total, concat(`fname`, ' ' , `lname`) as `student` from payment_history
					JOIN student ON student.student_id = payment_history.student_id
					JOIN payment_name ON payment_name.id = payment_history.payment_name_id 
					WHERE payment_date between '$date_from' AND '$date_to' AND payment_history.student_id = '$student_id'
					GROUP BY payment_name_id desc
					LIMIT 50";
			$query = $this->db->query($sql);
			return $query->result_array();
			
		};

	}

	/*
	*--------------------------------------------------
	*fetches the student information via class id 
	*--------------------------------------------------
	*/
	public function fetchStudentDataByClass($classId = null)
	{
		if($classId) {
			$sql = "SELECT * FROM student WHERE class_id = ?";
			$query = $this->db->query($sql, array($classId));
			return $query->result_array();
		} // /if
	} 

	/*
	*--------------------------------------------------
	* fetches the student infro via class and section id
	*--------------------------------------------------
	*/
	public function fetchStudentByClassAndSection($classId = null, $sectionId = null)
	{
		if($classId && $sectionId) {
			$sql = "SELECT * FROM student WHERE class_id = ? AND section_id = ?";
			$query = $this->db->query($sql, array($classId, $sectionId));
			return $query->result_array();
		} // /if
	}

	/*
	*-----------------------------------
	* update the student's inform
	*-----------------------------------
	*/	
	public function updateInfo($studentId = null)
	{
		if($studentId) {
			$update_data = array(
				'register_date' => $this->input->post('editRegisterDate'),
				'class_id' 		=> $this->input->post('editClassName'),
				'section_id'	=> $this->input->post('editSectionName'),
				'fname'			=> $this->input->post('editFname'),
				'lname' 		=> $this->input->post('editLname'),				
				'age'			=> $this->input->post('editAge'),
				'dob'			=> $this->input->post('editDob'),
				'sex'			=> $this->input->post('editSex'),
				'father_id'		=> $this->input->post('editFatherId'),
				'mother_id'		=> $this->input->post('editMotherId'),
				'contact'		=> $this->input->post('editContact'),
				'email'			=> $this->input->post('editEmail'),
				'address'		=> $this->input->post('editAddress'),
				'city'			=> $this->input->post('editCity'),
				'country'   	=> $this->input->post('editCountry')
			);

			$this->db->where('student_id', $studentId);
			$query = $this->db->update('student', $update_data);
			
			return ($query === true ? true : false);
		}			
	}

	/*
	*-----------------------------------
	* update the student's photo
	*-----------------------------------
	*/
	public function updatePhoto($studentId = null, $imageUrl = null)
	{
		if($studentId && $imageUrl) {
			$update_data = array(
				'image' 	=> $imageUrl
			);

			$this->db->where('student_id', $studentId);
			$query = $this->db->update('student', $update_data);
			
			return ($query === true ? true : false);
		}			
	}

	/*
	*-----------------------------------
	* remove the student's info
	*-----------------------------------
	*/
	public function remove($studentId = null) 
	{
		if($studentId) {
			$this->db->where('student_id', $studentId);
			$result = $this->db->delete('student');
			return ($result === true ? true: false); 
		} // /if
	}

	/*
	*-----------------------------------
	* insert bulk student
	*-----------------------------------
	*/
	public function createBulk()
	{				
		for($x = 1; $x <= count($this->input->post('bulkstfname')); $x++) {						
			$insert_data = array(				
				'class_id' 		=> $this->input->post('bulkstclassName')[$x],
				'section_id'	=> $this->input->post('bulkstsectionName')[$x],
				'image'			=> 'assets/images/default/default_avatar.png',
				'fname'			=> $this->input->post('bulkstfname')[$x],
				'lname' 		=> $this->input->post('bulkstlname')[$x]			
			);

			$status = $this->db->insert('student', $insert_data);						
		} // /for

		return ($status == true ? true : false);	
	}

	/*
	*-------------------------------------------
	* count total student
	*-------------------------------------------
	*/
	public function countTotalStudent()
	{
		$sql = "SELECT * FROM student";
		$query = $this->db->query($sql);
		return $query->num_rows();
	}
}
