<?php

 
class Payroll extends MY_Controller{
    function __construct()
    {
        parent::__construct();
		$this->isNotLoggedIn();
        $this->load->model('Payroll_model');
    } 

    /*
     * Listing of payroll
     */
    function index()
    {
        $data['payroll'] = $this->Payroll_model->get_all_payroll();
        $data['title'] = 'Payroll';
        $this->load->view('templates/header', $data);
        $this->load->view('payroll/index', $data);
		$this->load->view('templates/footer', $data);
    }

    /*
     * Adding a new payroll
     */
    function add()
    {   
        $this->load->library('form_validation');

		$this->form_validation->set_rules('payrollDate','PayrollDate','required');
		$this->form_validation->set_rules('payrollBasic','PayrollBasic','required');
		$this->form_validation->set_rules('payrollGross','PayrollGross','required');
		$this->form_validation->set_rules('payrollTax','PayrollTax','required');
		$this->form_validation->set_rules('payrollAllowance','PayrollAllowance','required');
		$this->form_validation->set_rules('payrollExpense','PayrollExpense','required');
		
		if($this->form_validation->run())     
        {   
            $params = array(
				'payrollWorker' => $this->input->post('payrollWorker'),
				'payrollDate' => $this->input->post('payrollDate'),
				'payrollBasic' => $this->input->post('payrollBasic'),
				'payrollGross' => $this->input->post('payrollGross'),
				'payrollNet' => $this->input->post('payrollNet'),
				'payrollTax' => $this->input->post('payrollTax'),
				'payrollAllowance' => $this->input->post('payrollAllowance'),
				'payrollExpense' => $this->input->post('payrollExpense'),
            );
            
            $payroll_id = $this->Payroll_model->add_payroll($params);
            redirect('payroll/index');
        }
        else
        {
			
			$data['title'] = 'payroll';
			$this->load->model('User_model');
			$data['all_users'] = $this->User_model->get_all_users();
            
			$data['title'] = 'Payroll';
        $this->load->view('templates/header', $data);
        $this->load->view('payroll/add', $data);
		$this->load->view('templates/footer', $data);
        }
    }  
	
	    /*
     * PAYSLIP a new payroll
     */
    function payslip($id)
    {   
        $this->load->library('form_validation');

		$this->form_validation->set_rules('payrollDate','PayrollDate','required');
		$this->form_validation->set_rules('payrollBasic','PayrollBasic','required');
		$this->form_validation->set_rules('payrollGross','PayrollGross','required');
		$this->form_validation->set_rules('payrollTax','PayrollTax','required');
		$this->form_validation->set_rules('payrollAllowance','PayrollAllowance','required');
		$this->form_validation->set_rules('payrollExpense','PayrollExpense','required');
		
		$today = date('Y-m-d');
		$worker = $this->db->get_where('payroll_user', array('id'=>$id))->row();
		$loan = $this->db->query("SELECT SUM(`LoanRepaymentAmount`) as `amount` FROM loan WHERE `LoanWorker` = '$id' 
									AND `LoanStatus` = 'Unpaid' 
									GROUP BY `LoanDate` asc, `LoanWorker` ")->row();
				

		if(ISSET($loan->amount)){
			$loan_amount = $loan->amount;
			$data['loan'] = $loan_amount;
		} else {
			$loan_amount = 0;
			$data['loan'] = $loan_amount;
		}
	
		$ssnitcalc = 5.5 / 100;
		$ssnitcalcemp = 13.5 / 100;
		
		$allowance = $worker->allowanceFuel + $worker->allowanceFood + $worker->allowanceClothes + $worker->allowanceAccommodation;
		$salary = $worker->salary;
		$ssnit = ($salary * $ssnitcalc); 
		$ssnitemp = ($salary * $ssnitcalcemp);
		$ssnittotal = $ssnit + $ssnitemp;		
		$grosspay =  $salary;
		$netpay =  ($salary - ($salary * $ssnitcalc)) - $loan_amount;
		
		
		$data['worker'] = $worker;
		$data['ssnit'] = $ssnit;
		$data['ssnitemp'] = $ssnitemp;
		$data['ssnittotal'] = $ssnittotal;
		$data['grosspay'] = $grosspay;
		$data['netpay'] = $netpay;
		

		
		$data['allowance'] = $allowance;
		
		if($this->form_validation->run())     
        {   
            $params = array(
				'payrollWorker' => $worker->id,
				'payrollDate' => $this->input->post('payrollDate'),
				'payrollBasic' => $this->input->post('payrollBasic'),
				'payrollGross' => $this->input->post('payrollGross'),
				'payrollNet' => $this->input->post('payrollNet'),
				'payrollTax' => $this->input->post('payrollTax'),
				'payrollAllowance' => $this->input->post('payrollAllowance'),
				'payrollExpense' => $this->input->post('payrollExpense'),
            );
            
            $payroll_id = $this->Payroll_model->add_payroll($params);
            redirect('payroll/index');
        }
        else
        {
			$this->load->model('User_model');
			$data['all_users'] = $this->User_model->get_all_users();
			$data['title'] = 'Payroll';
        $this->load->view('templates/header', $data);
        $this->load->view('payroll/add', $data);
		$this->load->view('templates/footer', $data);
        }
    }  

	//GEN PAYSLIP
	function generate($id){
			
		$today = date('Y-m-d');
		$worker = $this->db->get_where('payroll_user', array('id'=>$id))->row();
		$loan = $this->db->query("SELECT SUM(t1.`PaymentAmount`) as `amount` FROM loan_history t1
									JOIN loan t2 ON t2.id = t1.LoanId
									WHERE t2.`LoanWorker` = '$id' 
									AND t2.`LoanStatus` = 'Unpaid'	
									AND t1.`Source` = 'Salary'									
									GROUP BY t2.`id` asc ")->row();
		// LOAN WITH THE TYPE							
		$loan_e = $this->db->query("SELECT SUM(t1.`PaymentAmount`) as `amount`, t3.SLoanName FROM loan_history t1
									JOIN loan t2 ON t2.id = t1.LoanId
									JOIN settings_loan t3 ON t3.id = t2.LoanType
									
                                    
                                    WHERE t2.`LoanWorker` = '$id'
									AND t2.`LoanStatus` = 'Unpaid'	
									AND t1.`Source` = 'Salary'
									GROUP BY t1.`LoanId` asc")->result_array();							
			
				

		if(ISSET($loan->amount)){
			$loan_amount = $loan->amount;
			$data['loan'] = $loan_amount;
		} else {
			$loan_amount = 0;
			$data['loan'] = $loan_amount;
		}
	
		$ssnitcalc = 5.5 / 100;
		$ssnitcalcemp = 13.5 / 100;
		
		$allowance = $worker->allowanceFuel + $worker->allowanceFood + $worker->allowanceClothes + $worker->allowanceAccommodation;
		$salary = $worker->salary;
		$ssnit = ($salary * $ssnitcalc); 
		$ssnitemp = ($salary * $ssnitcalcemp);
		$ssnittotal = $ssnit + $ssnitemp;		
		$grosspay =  $salary;
		$netpay =  ($salary - ($salary * $ssnitcalc)) - $loan_amount;
		
		// TYPES OF ALLOWANCES 

		$data['all_allowance'] = array(
			'Fuel' => $worker->allowanceFuel,
			'Food' => $worker->allowanceFood,
			'Clothes' => $worker->allowanceClothes,
			'Accommodation' => $worker->allowanceAccommodation,
		);
		
		$other = $worker->otherPayment;
		
		$data['other'] = $other;
		$data['loan_e'] = $loan_e;
		$data['deduction'] = $loan_amount + $ssnit;
		$data['real_net'] = ($salary + $allowance) - ($loan_amount + $ssnit + $other);
		//$data['loan_e'] = $this->db->get_where('loan', array('LoanWorker' => $id))->result_array();		
		$data['worker'] = $worker;
		$data['ssnit'] = $ssnit;
		$data['ssnitemp'] = $ssnitemp;
		$data['ssnittotal'] = $ssnittotal;
		$data['id'] = $id;
		$data['title'] = 'Payroll';
		//$data['grosspay'] = $grosspay;
		//$data['netpay'] = $netpay;
		

		
		$data['allowance'] = $allowance;
			
			$this->load->model('User_model');
			$data['all_users'] = $this->User_model->get_all_users();
			
			
        $this->load->view('templates/header', $data);
        $this->load->view('payroll/generate', $data);
		$this->load->view('templates/footer', $data);
			
			
	}
	
	
	// GENERATE ALL

	function generate_all(){
			$data['title'] = 'payroll';
		$month_gen = $this->input->get('month');
			// AFTER RENDERING
        $this->load->view('templates/header', $data);
        $this->load->view('payroll/generate_all', $data);
		$this->load->view('templates/footer', $data);
		
		
			
	}
	
	function save($id, $month){
			
				$today = date('Y-m-d');
				$worker = $this->db->get_where('payroll_user', array('id'=>$id))->row();
				
				
				$loan = $this->db->query("SELECT SUM(t1.`PaymentAmount`) as `amount` FROM loan_history t1
											JOIN loan t2 ON t2.id = t1.LoanId
											WHERE t2.`LoanWorker` = '$id' 
											AND t2.`LoanStatus` = 'Unpaid'	
											AND t1.`Source` = 'Salary'									
											GROUP BY t2.`id` asc ")->row();			
				
				// LOAN WITH THE TYPE							
				$loan_e = $this->db->query("SELECT SUM(t1.`PaymentAmount`) as `amount`, t3.SLoanName FROM loan_history t1
											JOIN loan t2 ON t2.id = t1.LoanId
											JOIN settings_loan t3 ON t3.id = t2.LoanType
											
											
											WHERE t2.`LoanWorker` = '$id'
											AND t2.`LoanStatus` = 'Unpaid'	
											AND t1.`Source` = 'Salary'
											GROUP BY t1.`LoanId` asc")->result_array();							
					
						

				if(ISSET($loan->amount)){
					$loan_amount = $loan->amount;
					$data['loan'] = $loan_amount;
				} else {
					$loan_amount = 0;
					$data['loan'] = $loan_amount;
				}
			
				$ssnitcalc = 5.5 / 100;
				$ssnitcalcemp = 13.5 / 100;
				
				$allowance = $worker->allowanceFuel + $worker->allowanceFood + $worker->allowanceClothes + $worker->allowanceAccommodation;
				$salary = $worker->salary ? $worker->salary : 0; 
				$ssnit = ($salary * $ssnitcalc); 
				$ssnitemp = ($salary * $ssnitcalcemp);
				$ssnittotal = $ssnit + $ssnitemp;		
				$grosspay =  $salary;
				$netpay =  ($salary - ($salary * $ssnitcalc)) - $loan_amount;
				
				// TYPES OF ALLOWANCES 

				$data['all_allowance'] = array(
					'Fuel' => $worker->allowanceFuel,
					'Food' => $worker->allowanceFood,
					'Clothes' => $worker->allowanceClothes,
					'Accommodation' => $worker->allowanceAccommodation,
				);
				
				$other = $worker->otherPayment;
				
				$deduction = $loan_amount + $ssnit;
				$real_net = ($salary + $allowance) - ($loan_amount + $ssnit + $other);	
			
				// MONTH GENERATING FOR -- GIVE VALUE IF NON SELECTED
				//$month = $this->input->get('month') ? $this->input->get('month') : date('Y-m-d');
				$month_gen = $month;
				
	       $params = array(
				'payrollWorker' => $id,
				'payrollDate' => date('Y-m-t', strtotime($month_gen)),
				'payrollBasic' => $salary,
				'payrollGross' => ($grosspay + $allowance),
				'payrollNet' => $real_net,
				'payrollTax' => $ssnit,
				'payrollAllowance' => $allowance,
				'payrollExpense' => $deduction,
				'payrollGenerated' => $today,
            );
            
			if($params){
				
				$search = $this->db->get_where('Payroll', array('payrollWorker' => $id));
				$count = $search->num_rows();
				$needle = $search->row();
				
				// MONTH GENERATING FOR -- GIVE VALUE IF NON SELECTED
				//$month = $this->input->get('month') ? $this->input->get('month') : date('Y-m-d');
				$month_gen = $month;
				
				// CHECK IF THERE HAS BEEN A PAYROLL CREATED FOR THIS USER FOR THIS YEAR/MONTH				
				$sql = "SELECT * from Payroll where `payrollWorker` = '{$id}' AND `payrollDate` LIKE '%{$month_gen}%'";
				$search = $this->db->query($sql)->row();

				$count = $this->db->query($sql)->num_rows();
				//$needle = $search;
								
				if($count > 0) {
						$db_gen = date('Y-M', strtotime($search->payrollDate));
				}
				
				if($count > 0) {
								echo 'Already Exists';
					} else {
								
						// SAVE IN DB	
					$payroll_id = $this->Payroll_model->add_payroll($params);
				}
			}
					
							
	}
	
	
	
		function save_all($month){
			
		$all = $this->db->get_where('payroll_user')->result_array();		
		$month = $month;
		$month_gen = $month;
		
		foreach($all as $alls) {
 
				$id = $alls['id'];
			
				// BEGINNING OF THE MONTH
				//$firstofmonth = date('Y-m', strtotime($month_input));	
					
				// END OF THE MONTH	
					if(!empty($month_gen)){
						$month = date('Y-m', strtotime($month_gen));
					} else {
						$month = $month_gen;
					}
			
			
				$today = date('Y-m-d');
				$worker = $this->db->get_where('payroll_user', array('id'=>$id))->row();
								
				$loan = $this->db->query("SELECT SUM(t1.`PaymentAmount`) as `amount` FROM loan_history t1
											JOIN loan t2 ON t2.id = t1.LoanId
											WHERE t2.`LoanWorker` = '$id' 
											AND t2.`LoanStatus` = 'Unpaid'	
											AND t1.`Source` = 'Salary'									
											GROUP BY t2.`id` asc ")->row();			
				
				// LOAN WITH THE TYPE							
				$loan_e = $this->db->query("SELECT SUM(t1.`PaymentAmount`) as `amount`, t3.SLoanName FROM loan_history t1
											JOIN loan t2 ON t2.id = t1.LoanId
											JOIN settings_loan t3 ON t3.id = t2.LoanType
											
											
											WHERE t2.`LoanWorker` = '$id'
											AND t2.`LoanStatus` = 'Unpaid'	
											AND t1.`Source` = 'Salary'
											GROUP BY t1.`LoanId` asc")->result_array();							
					
						

				if(ISSET($loan->amount)){
					$loan_amount = $loan->amount;
					$loan = $loan_amount;
				} else {
					$loan_amount = 0;
					$loan = $loan_amount;
				}
			
				$ssnitcalc = 5.5 / 100;
				$ssnitcalcemp = 13.5 / 100;
				
				$allowance = $worker->allowanceFuel + $worker->allowanceFood + $worker->allowanceClothes + $worker->allowanceAccommodation;
				$salary = $worker->salary ? $worker->salary : 0; 
				$ssnit = ($salary * $ssnitcalc); 
				$ssnitemp = ($salary * $ssnitcalcemp);
				$ssnittotal = $ssnit + $ssnitemp;		
				$grosspay =  $salary;
				$netpay =  ($salary - ($salary * $ssnitcalc)) - $loan_amount;
				
				// TYPES OF ALLOWANCES 

				$all_allowance = array(
					'Fuel' => $worker->allowanceFuel,
					'Food' => $worker->allowanceFood,
					'Clothes' => $worker->allowanceClothes,
					'Accommodation' => $worker->allowanceAccommodation,
				);
				
				$other = $worker->otherPayment;
				
				$deduction = $loan_amount + $ssnit;
				$real_net = ($salary + $allowance) - ($loan_amount + $ssnit + $other);	
							// MONTH GENERATING FOR -- GIVE VALUE IF NON SELECTED
				//$month = $this->input->get('month') ? $this->input->get('month') : '';
				//$month_gen = $month;
				
	       $params = array(
				'payrollWorker' => $id,
				'payrollDate' => date('Y-m-t', strtotime($month_gen)),
				'payrollBasic' => $salary,
				'payrollGross' => ($grosspay + $allowance),
				'payrollNet' => $real_net,
				'payrollTax' => $ssnit,
				'payrollAllowance' => $allowance,
				'payrollExpense' => $deduction,
				'payrollGenerated' => $today,
            );
			
			if($params){
				
				// CHECK IF THERE HAS BEEN A PAYROLL CREATED FOR THIS USER FOR THIS YEAR/MONTH
				
				$sql = "SELECT * from Payroll where `payrollWorker` = '{$id}' AND `payrollDate` LIKE '%{$month_gen}%'";
				$search = $this->db->query($sql)->row();

				$count = $this->db->query($sql)->num_rows();
				//$needle = $search;
				

				

				
				if($count > 0) {
						$db_gen = date('Y-M', strtotime($search->payrollDate));
				}
				
				if($count > 0) {
								echo 'Already Exists';
					} else {
								
						// SAVE IN DB	
					$payroll_id = $this->Payroll_model->add_payroll($params);
				}
				
				
				
			}
		}
					
	}
	
	
	
    /*
     * Editing a payroll
     */
    function edit($id)
    {   
        // check if the payroll exists before trying to edit it
        $data['payroll'] = $this->Payroll_model->get_payroll($id);
        
        if(isset($data['payroll']['id']))
        {
            $this->load->library('form_validation');

			$this->form_validation->set_rules('payrollDate','PayrollDate','required');
			$this->form_validation->set_rules('payrollBasic','PayrollBasic','required');
			$this->form_validation->set_rules('payrollGross','PayrollGross','required');
			$this->form_validation->set_rules('payrollTax','PayrollTax','required');
			$this->form_validation->set_rules('payrollAllowance','PayrollAllowance','required');
			$this->form_validation->set_rules('payrollExpense','PayrollExpense','required');
		
			if($this->form_validation->run())     
            {   
                $params = array(
					'payrollWorker' => $this->input->post('payrollWorker'),
					'payrollDate' => $this->input->post('payrollDate'),
					'payrollBasic' => $this->input->post('payrollBasic'),
					'payrollGross' => $this->input->post('payrollGross'),
					'payrollTax' => $this->input->post('payrollTax'),
					'payrollAllowance' => $this->input->post('payrollAllowance'),
					'payrollExpense' => $this->input->post('payrollExpense'),
                );

                $this->Payroll_model->update_payroll($id,$params);            
                redirect('payroll/index');
            }
            else
            {
				$this->load->model('User_model');
				$data['all_users'] = $this->User_model->get_all_users();
				$data['title'] = 'Payroll';
        $this->load->view('templates/header', $data);
        $this->load->view('payroll/edit', $data);
		$this->load->view('templates/footer', $data);
            }
        }
        else
            show_error('The payroll you are trying to edit does not exist.');
    } 

    /*
     * Deleting payroll
     */
    function remove($id)
    {
        $payroll = $this->Payroll_model->get_payroll($id);

        // check if the payroll exists before trying to delete it
        if(isset($payroll['id']))
        {
            $this->Payroll_model->delete_payroll($id);
            redirect('payroll/index');
        }
        else
            show_error('The payroll you are trying to delete does not exist.');
    }
    
}
