<?php 

class Pages extends MY_Controller
{
	public function view($page = 'login')
	{
        if (!file_exists(APPPATH.'views/'.$page.'.php'))
        {
            // Whoops, we don't have a page for that!
            show_404();
        }

        $data['title'] = ucfirst($page); // Capitalize the first letter

        if($page == 'section' || $page == 'subject' || $page == 'student' || $page == 'parents' || $page == 'marksheet' || $page == 'accounting') {
            $this->load->model('model_classes');
            $data['classData'] = $this->model_classes->fetchClassData();

            $this->load->model('model_teacher');
            $data['teacherData'] = $this->model_teacher->fetchTeacherData();
			
			$this->load->model('model_parents');
            $data['parentsData'] = $this->model_parents->fetchParentsData();
			$data['parentsDataMale'] = $this->model_parents->fetchParentsDataMale();
			$data['parentsDataFemale'] = $this->model_parents->fetchParentsDataFemale();
			
			$this->load->model('model_subject');
            $data['subjectData'] = $this->model_subject->fetchSubjectDataByClass($classId = 1);

            
            $this->load->model('model_accounting');
            $data['totalIncome'] = $this->model_accounting->totalIncome();
			$data['totalProjectedIncome'] = $this->model_accounting->totalProjectedIncome();
            $data['totalExpenses'] = $this->model_accounting->totalExpenses();
            $data['totalBudget'] = $this->model_accounting->totalBudget();
			$data['totalReceivedBudget'] = $this->model_accounting->totalReceivedBudget();
			$data['totalReceivedIncome'] = $this->model_accounting->totalReceivedIncome();
						
        }
		
		 if($page == 'loan/index' ) {
            $this->load->model('model_classes');
            $data['classData'] = $this->model_classes->fetchClassData();

            $this->load->model('model_teacher');
            $data['teacherData'] = $this->model_teacher->fetchTeacherData();
			
			$this->load->model('model_parents');
            $data['parentsData'] = $this->model_parents->fetchParentsData();
			$data['parentsDataMale'] = $this->model_parents->fetchParentsDataMale();
			$data['parentsDataFemale'] = $this->model_parents->fetchParentsDataFemale();
			
			$this->load->model('model_subject');
            $data['subjectData'] = $this->model_subject->fetchSubjectDataByClass($classId = 1);

            
            $this->load->model('model_accounting');
            $data['totalIncome'] = $this->model_accounting->totalIncome();
			$data['totalProjectedIncome'] = $this->model_accounting->totalProjectedIncome();
            $data['totalExpenses'] = $this->model_accounting->totalExpenses();
            $data['totalBudget'] = $this->model_accounting->totalBudget();
			$data['totalReceivedBudget'] = $this->model_accounting->totalReceivedBudget();
			$data['totalReceivedIncome'] = $this->model_accounting->totalReceivedIncome();
						
        }
		
		if($page == 'report') {
			$this->load->model('model_report');
			
			$this->load->model('model_student');
            $data['studentData'] = $this->model_student->fetchStudentData();
			
			$sel = $this->input->post('student_id') ? $this->input->post('student_id') : '';
			$student_id = $this->input->post('student_id') ? $this->input->post('student_id') : '';
			$date_from = $this->input->post('date_from') ? $this->input->post('date_from') : date('Y-m-d');
			$date_to = $this->input->post('date_to') ? $this->input->post('date_to') : date('Y-m-d');
			$summary = $this->input->post('summary') ? $this->input->post('summary') : '';
			
			$invoice_amount = $this->db->query("SELECT sum(payment_name.total_amount) as 'invoice' FROM `payment_name`
												JOIN `payment` ON payment.payment_name_id = payment_name.id
												JOIN `student` ON student.student_id = payment.student_id
												WHERE student.student_id IN('{$student_id}')
												AND payment_date between '$date_from' AND '$date_to'
												")->row()->invoice;
												
			$payment_amount = $this->db->query("SELECT sum(payment.paid_amount) as 'payment' FROM `payment_name`
												JOIN `payment` ON payment.payment_name_id = payment_name.id
												JOIN `student` ON student.student_id = payment.student_id
												WHERE student.student_id IN('{$student_id}')
												AND payment_date between '$date_from' AND '$date_to'")->row()->payment;									
			
				if(!empty($date_from) && !empty($date_to)) {
					$data['expense'] = $this->model_report->fetchExpenseReport($date_from,$date_to);
					$data['income'] = $this->model_report->fetchIncomeReport($date_from,$date_to);
					$data['incomeStudent'] = $this->model_report->fetchIncomeStudentReport($date_from,$date_to,$student_id,$summary);
					$data['date_from'] = $date_from;
					$data['date_to'] = $date_to;
					$data['student_id'] = $student_id;
					$data['summary'] = $summary;
					$data['invoice_amount'] = $invoice_amount;
					$data['payment_amount'] = $payment_amount;

					$data['sel'] = $sel;

				}
		
		}

        if($page == 'setting') {
            $this->load->model('model_users');
            $this->load->library('session');
            $userId = $this->session->userdata('id')['user_id'];
            $data['userData'] = $this->model_users->fetchUserData($userId);
        }

        if($page == 'dashboard') {
            $this->load->model('model_student');
            $this->load->model('model_teacher');
            $this->load->model('model_classes');
            $this->load->model('model_marksheet');
            $this->load->model('model_accounting');

            $data['countTotalStudent'] = $this->model_student->countTotalStudent();
			$data['studentBirthday'] = $this->model_student->fetchStudentBirthdayData();
            $data['countTotalTeacher'] = $this->model_teacher->countTotalTeacher();
            $data['countTotalClasses'] = $this->model_classes->countTotalClass();
            $data['countTotalMarksheet'] = $this->model_marksheet->countTotalMarksheet();

            $data['totalIncome'] = $this->model_accounting->totalIncome();
			$data['totalProjectedIncome'] = $this->model_accounting->totalProjectedIncome();
            $data['totalExpenses'] = $this->model_accounting->totalExpenses();
            $data['totalBudget'] = $this->model_accounting->totalBudget();
			$data['totalReceivedBudget'] = $this->model_accounting->totalReceivedBudget();
			$data['totalReceivedIncome'] = $this->model_accounting->totalReceivedIncome();
			
        }

        if($page == 'login') {
            $this->isLoggedIn();
            $this->load->view($page, $data);
        } 
        else{
            $this->isNotLoggedIn();

            $this->load->view('templates/header', $data);
            $this->load->view($page, $data);    
            $this->load->view('templates/footer', $data);    
        }
	}
    
}