<?php 

class Model_Parents extends CI_Model
{
	public function __construct()
	{
		parent::__construct();
	}

	/*
	*------------------------------------
	* inserts the parentss information
	* into the database 
	*------------------------------------
	*/
	public function create($img_url)
	{
		if($img_url == '') {
			$img_url = 'assets/images/default/default_avatar.png';
		} 

		$insert_data = array(
			'register_date' => $this->input->post('registerDate'),
			'fname' 		=> $this->input->post('fname'),
			'lname'			=> $this->input->post('lname'),
			'image'			=> $img_url,
			'date_of_birth' => $this->input->post('dob'),
			'age'			=> $this->input->post('age'),
			'sex'			=> $this->input->post('sex'),
			'contact'		=> $this->input->post('contact'),
			'email'			=> $this->input->post('email'),
			'address'		=> $this->input->post('address'),
			'city'			=> $this->input->post('city'),
			'country'		=> $this->input->post('country'),
			'job_type'		=> $this->input->post('jobType')
		);

		$status = $this->db->insert('parents', $insert_data);		
		return ($status == true ? true : false);
	}

	/*
	*------------------------------------
	* retrieves parents information 
	*------------------------------------
	*/
	public function fetchParentsData($parentsId = null)	
	{
		if($parentsId) {
			$sql = "SELECT * FROM parents WHERE parents_id = ?";
			$query = $this->db->query($sql, array($parentsId));
			$result = $query->row_array();
			return $result;
		}

		$sql = "SELECT * FROM parents";
		$query = $this->db->query($sql);
		$result = $query->result_array();
		return $result;
	}
	
		/*
	*------------------------------------
	* retrieves parents information   MALE
	*------------------------------------
	*/
	public function fetchParentsDataMale($parentsId = null)	
	{

		$sql = "SELECT * FROM parents WHERE sex = 'Male'";
		$query = $this->db->query($sql);
		$result = $query->result_array();
		return $result;
	}
	
		/*
	*------------------------------------
	* retrieves parents information  FEMALE
	*------------------------------------
	*/
	public function fetchParentsDataFemale($parentsId = null)	
	{
		$sql = "SELECT * FROM parents WHERE sex = 'Female'";
		$query = $this->db->query($sql);
		$result = $query->result_array();
		return $result;
	}

	
	
	/*
	*------------------------------------
	* updates parents information
	*------------------------------------
	*/
	public function updateInfo($parentsId = null)
	{
		if($parentsId) {
			$update_data = array(
				'register_date' 	=> $this->input->post('editRegisterDate'),
				'fname' 			=> $this->input->post('editFname'),
				'lname' 			=> $this->input->post('editLname'),
				'date_of_birth'     => $this->input->post('editDob'),
				'age'				=> $this->input->post('editAge'),
				'sex'			    => $this->input->post('editSex'),
				'contact'			=> $this->input->post('editContact'),
				'email'				=> $this->input->post('editEmail'),
				'address'			=> $this->input->post('editAddress'),
				'city'				=> $this->input->post('editCity'),	
				'country'			=> $this->input->post('editCountry'),
				'job_type'			=> $this->input->post('editJobType')
			);

			$this->db->where('parents_id', $parentsId);
			$query = $this->db->update('parents', $update_data);
			
			return ($query === true ? true : false);
		}			
	}

	/*
	*------------------------------------
	* updates parents information
	*------------------------------------
	*/
	public function updatePhoto($parentsId = null, $imageUrl = null)
	{
		if($parentsId && $imageUrl) {
			$update_data = array(
				'image' 	=> $imageUrl
			);

			$this->db->where('parents_id', $parentsId);
			$query = $this->db->update('parents', $update_data);
			
			return ($query === true ? true : false);
		}			
	}

	/*
	*------------------------------------
	* removes parents information 
	*------------------------------------
	*/
	public function remove($parentsId = null)
	{
		if($parentsId) {
			$this->db->where('parents_id', $parentsId);
			$result = $this->db->delete('parents');
			return ($result === true ? true: false); 
		} // /if
	}

	/*
	*------------------------------------
	* count total parents information 
	*------------------------------------
	*/	
	public function countTotalParents() 
	{
		$sql = "SELECT * FROM parents";
		$query = $this->db->query($sql);
		return $query->num_rows();
	}
}