<?php
//PAYROLL USER CONTROLLER
class User extends MY_Controller{
    function __construct()
    {
        parent::__construct();
			$this->isNotLoggedIn();
        $this->load->model('User_model');

		// loading the users model
		$this->load->model('model_users');

		// loading the form validation library
		$this->load->library('form_validation');
		
		$data['title'] = 'Staff';
    } 

    /*
     * Listing of users
     */
    function index()
    {
        $data['users'] = $this->User_model->get_all_users_emp();
        $data['title'] = 'Staff';
		
        $this->load->view('templates/header', $data);
        $this->load->view('user/index', $data);
		$this->load->view('templates/footer', $data);
    }
	
		public function newProfile()
	{
		//$this->load->library('session');

		$validator = array('success' => false, 'messages' => array());

		$validate_data = array(
			array(
				'field' => 'username',
				'label' => 'Username',
				'rules' => 'required'
			),
			array(
				'field' => 'password',
				'label' => 'Password',
				'rules' => 'required'
			),
			array(
				'field' => 'role',
				'label' => 'Access Level',
				'rules' => 'required'
			)
		);

		$this->form_validation->set_rules($validate_data);
		$this->form_validation->set_error_delimiters('<p class="text-danger">','</p>');

		if($this->form_validation->run() === true) {	
			$update = $this->model_users->registerProfile();					
			if($update === true) {
				$validator['success'] = true;
				$validator['messages'] = "Successfully Update";
				redirect('dashboard');
			}
			else {
				$validator['success'] = false;
				$validator['messages'] = "Error while inserting the information into the database";
			}			
		} 	
		else {
			$validator['success'] = false;
			foreach ($_POST as $key => $value) {
				$validator['messages'][$key] = form_error($key);
			}			
		} // /else
		
		$data['title'] = "New Account";
		$this->load->view('templates/header', $data);
        $this->load->view('account', $data);
		$this->load->view('templates/footer', $data);

			
			
	}
	

    /*
     * Adding a new user
     */
    function add()
    {   
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $params = array(
				'password' => $this->input->post('password'),
				'username' => $this->input->post('username'),
				'email' => $this->input->post('email'),
				'remember_token' => $this->input->post('remember_token'),
				'fullName' => $this->input->post('fullName'),
				'role' => $this->input->post('role'),
				'salary' => $this->input->post('salary'),
				'activated' => $this->input->post('activated'),
				'studentRollId' => $this->input->post('studentRollId'),
				'birthday' => $this->input->post('birthday'),
				'gender' => $this->input->post('gender'),
				'phoneNo' => $this->input->post('phoneNo'),
				'mobileNo' => $this->input->post('mobileNo'),
				'creditAmount' => $this->input->post('creditAmount'),
				'studentAcademicYear' => $this->input->post('studentAcademicYear'),
				'studentClass' => $this->input->post('studentClass'),
				'studentSection' => $this->input->post('studentSection'),
				'parentProfession' => $this->input->post('parentProfession'),
				'photo' => $this->input->post('photo'),
				'restoreUniqId' => $this->input->post('restoreUniqId'),
				'transport' => $this->input->post('transport'),
				'hostel' => $this->input->post('hostel'),
				'defLang' => $this->input->post('defLang'),
				'defTheme' => $this->input->post('defTheme'),
				'updated_at' => $this->input->post('updated_at'),
				'customPermissionsType' => $this->input->post('customPermissionsType'),
				'auth_session' => $this->input->post('auth_session'),
				'address' => $this->input->post('address'),
				'parentOf' => $this->input->post('parentOf'),
				'isLeaderBoard' => $this->input->post('isLeaderBoard'),
				'medical' => $this->input->post('medical'),
				'comVia' => $this->input->post('comVia'),
				'customPermissions' => $this->input->post('customPermissions'),
				'firebase_token' => $this->input->post('firebase_token'),
            );
            
            $user_id = $this->User_model->add_user($params);
            redirect('user/index');
        }
        else
        {            
		$data['title'] = 'Staff';
        $this->load->view('templates/header', $data);
        $this->load->view('user/add', $data);
		$this->load->view('templates/footer', $data);
        }
    }  

    /*
     * Editing a user
     */
    function edit($id)
    {   
        // check if the user exists before trying to edit it
        $data['user'] = $this->User_model->get_user($id);
        
        if(isset($data['user']['id']))
        {
            if(isset($_POST) && count($_POST) > 0)     
            {   
                $params = array(
					'password' => $this->input->post('password'),
					'username' => $this->input->post('username'),
					'email' => $this->input->post('email'),
					'remember_token' => $this->input->post('remember_token'),
					'fullName' => $this->input->post('fullName'),
					'role' => $this->input->post('role'),
					'salary' => $this->input->post('salary'),
					'activated' => $this->input->post('activated'),
					'studentRollId' => $this->input->post('studentRollId'),
					'birthday' => $this->input->post('birthday'),
					'gender' => $this->input->post('gender'),
					'phoneNo' => $this->input->post('phoneNo'),
					'mobileNo' => $this->input->post('mobileNo'),
					'creditAmount' => $this->input->post('creditAmount'),
					'studentAcademicYear' => $this->input->post('studentAcademicYear'),
					'studentClass' => $this->input->post('studentClass'),
					'studentSection' => $this->input->post('studentSection'),
					'parentProfession' => $this->input->post('parentProfession'),
					'photo' => $this->input->post('photo'),
					'restoreUniqId' => $this->input->post('restoreUniqId'),
					'transport' => $this->input->post('transport'),
					'hostel' => $this->input->post('hostel'),
					'defLang' => $this->input->post('defLang'),
					'defTheme' => $this->input->post('defTheme'),
					'updated_at' => $this->input->post('updated_at'),
					'customPermissionsType' => $this->input->post('customPermissionsType'),
					'auth_session' => $this->input->post('auth_session'),
					'address' => $this->input->post('address'),
					'parentOf' => $this->input->post('parentOf'),
					'isLeaderBoard' => $this->input->post('isLeaderBoard'),
					'medical' => $this->input->post('medical'),
					'comVia' => $this->input->post('comVia'),
					'customPermissions' => $this->input->post('customPermissions'),
					'firebase_token' => $this->input->post('firebase_token'),
                );

                $this->User_model->update_user($id,$params);            
                redirect('user/index');
            }
            else
            {
		$data['title'] = 'Staff';
        $this->load->view('templates/header', $data);
        $this->load->view('user/edit', $data);
		$this->load->view('templates/footer', $data);
            }
        }
        else
            show_error('The user you are trying to edit does not exist.');
    } 
	
	
	// ALLOWANCE
	   /*
     * Editing a user
     */
    function allowance($id)
    {   
        // check if the user exists before trying to edit it
        $data['user'] = $this->User_model->get_user($id);
        
        if(isset($data['user']['id']))
        {
            if(isset($_POST) && count($_POST) > 0)     
            {   
                $params = array(
					'allowanceFuel' => $this->input->post('allowanceFuel'),
					'allowanceClothes' => $this->input->post('allowanceClothes'),
					'allowanceFood' => $this->input->post('allowanceFood'),
					'allowanceAccommodation' => $this->input->post('allowanceAccommodation'),
					'otherPayment' => $this->input->post('otherPayment'),
					'salary' => $this->input->post('salary'),
					'paymentMethod' => $this->input->post('paymentMethod'),
                );

                $this->User_model->update_user($id,$params);            
                redirect('user/index');
            }
            else
            {
		$data['title'] = 'Staff';
        $this->load->view('templates/header', $data);
        $this->load->view('user/allowance', $data);
		$this->load->view('templates/footer', $data);
            }
        }
        else
            show_error('The user you are trying to edit does not exist.');
    } 

    /*
     * Deleting user
     */
    function remove($id)
    {
        $user = $this->User_model->get_user($id);

        // check if the user exists before trying to delete it
        if(isset($user['id']))
        {
            $this->User_model->delete_user($id);
            redirect('user/index');
        }
        else
            show_error('The user you are trying to delete does not exist.');
    }
    
}
