<?php
 
class Settings_loan extends MY_Controller{
    function __construct()
    {
        parent::__construct();
			$this->isNotLoggedIn();
        $this->load->model('Settings_loan_model');
    } 

    /*
     * Listing of settings_loan
     */
    function index()
    {
        $data['settings_loan'] = $this->Settings_loan_model->get_all_settings_loan();
        $data['title'] = 'Payroll';
		
        $this->load->view('templates/header', $data);
        $this->load->view('setting_loan/index', $data);
		$this->load->view('templates/footer', $data);
    }

    /*
     * Adding a new settings_loan
     */
    function add()
    {   
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $params = array(
				'SLoanName' => $this->input->post('SLoanName'),
				'SLoanDescription' => $this->input->post('SLoanDescription'),
            );
            
            $settings_loan_id = $this->Settings_loan_model->add_settings_loan($params);
            redirect('settings_loan/index');
        }
        else
        {            
		$data['title'] = 'Payroll';
        $this->load->view('templates/header', $data);
        $this->load->view('setting_loan/add', $data);
		$this->load->view('templates/footer', $data);
        }
    }  

    /*
     * Editing a settings_loan
     */
    function edit($id)
    {   
        // check if the settings_loan exists before trying to edit it
        $data['settings_loan'] = $this->Settings_loan_model->get_settings_loan($id);
        
        if(isset($data['settings_loan']['id']))
        {
            if(isset($_POST) && count($_POST) > 0)     
            {   
                $params = array(
					'SLoanName' => $this->input->post('SLoanName'),
					'SLoanDescription' => $this->input->post('SLoanDescription'),
                );

                $this->Settings_loan_model->update_settings_loan($id,$params);            
                redirect('settings_loan/index');
            }
            else
            {
		$data['title'] = 'Payroll';
        $this->load->view('templates/header', $data);
        $this->load->view('setting_loan/edit', $data);
		$this->load->view('templates/footer', $data);
            }
        }
        else
            show_error('The settings_loan you are trying to edit does not exist.');
    } 

    /*
     * Deleting settings_loan
     */
    function remove($id)
    {
        $settings_loan = $this->Settings_loan_model->get_settings_loan($id);

        // check if the settings_loan exists before trying to delete it
        if(isset($settings_loan['id']))
        {
            $this->Settings_loan_model->delete_settings_loan($id);
            redirect('settings_loan/index');
        }
        else
            show_error('The settings_loan you are trying to delete does not exist.');
    }
    
}
