<?php
 
class Loan_history extends MY_Controller{
    function __construct()
    {
        parent::__construct();
			$this->isNotLoggedIn();
        $this->load->model('Loan_history_model');
    } 

    /*
     * Listing of loan_history
     */
    function index()
    {
        $data['loan_history'] = $this->Loan_history_model->get_all_loan_history();
        $data['title'] = 'Loan Repayment';
		
        $this->load->view('templates/header', $data);
        $this->load->view('loan_history/index', $data);
		$this->load->view('templates/footer', $data);
    }

    /*
     * Adding a new loan_history
     */
    function add()
    {   
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $params = array(
				'LoanId' => $this->input->post('LoanId'),
				'PaymentDate' => $this->input->post('PaymentDate'),
				'PaymentAmount' => $this->input->post('PaymentAmount'),
				'Balance' => $this->input->post('Balance'),
            );
            
            $loan_history_id = $this->Loan_history_model->add_loan_history($params);
            redirect('loan_history/index');
        }
        else
        {            
		$data['title'] = 'Loan Repayment';
        $this->load->view('templates/header', $data);
        $this->load->view('loan_history/add', $data);
		$this->load->view('templates/footer', $data);
        }
    }  
	
	   function pay($id)
    {   
	
		$worker = $this->db->get_where('loan', array('id' => $id))->row()->LoanWorker;
		$balance = $this->db->get_where('loan', array('id' => $id))->row()->LoanBalance;
		$employee = $this->db->get_where('payroll_user', array('id' => $worker))->row()->fullName;
		
		
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $params = array(
				'LoanId' => $this->input->post('LoanId'),
				'PaymentDate' => $this->input->post('PaymentDate'),
				'PaymentAmount' => $this->input->post('PaymentAmount'),
				'Balance' => $this->input->post('Balance'),
            );
            
            $loan_history_id = $this->Loan_history_model->add_loan_history($params);
            
			// UPDATE BALANCE ON MAIN Loan TABLE
				$balance = $this->input->post('Balance');
				$loan_id = $this->input->post('LoanId'); 
			
					$loanparams = array(
						'id' => $loan_id,
						'LoanBalance' => $balance,			
					);
				
				$this->db->where('id', $loan_id);
				$update = $this->db->update('loan', $loanparams);
				
				//echo $update;
	 
			
			redirect('loan_history/index');
        }
        else
        {   
			$data['loan_history'] = $this->db->get_where('loan_history', array('LoanId' => $id))->result_array();
			$data['employee'] = $employee;
			$data['balance'] = $balance;
			$data['id'] = $id;
			$data['title'] = 'Loan Repayment';
        $this->load->view('templates/header', $data);
        $this->load->view('loan_history/add', $data);
		$this->load->view('templates/footer', $data);
        }
    }  

    /*
     * Editing a loan_history
     */
    function edit($id)
    {   
        // check if the loan_history exists before trying to edit it
        $data['loan_history'] = $this->Loan_history_model->get_loan_history($id);
        
        if(isset($data['loan_history']['id']))
        {
            if(isset($_POST) && count($_POST) > 0)     
            {   
                $params = array(
					'LoanId' => $this->input->post('LoanId'),
					'PaymentDate' => $this->input->post('PaymentDate'),
					'PaymentAmount' => $this->input->post('PaymentAmount'),
					'Balance' => $this->input->post('Balance'),
                );

                $this->Loan_history_model->update_loan_history($id,$params);            
                redirect('loan_history/index');
            }
            else
            {
		$data['title'] = 'Loan Repayment';
        $this->load->view('templates/header', $data);
        $this->load->view('loan_history/edit', $data);
		$this->load->view('templates/footer', $data);
            }
        }
        else
            show_error('The loan_history you are trying to edit does not exist.');
    } 

    /*
     * Deleting loan_history
     */
    function remove($id)
    {
        $loan_history = $this->Loan_history_model->get_loan_history($id);

        // check if the loan_history exists before trying to delete it
        if(isset($loan_history['id']))
        {

			
			// GET PAYMENT AMOUNT
			$payment = (float)$loan_history['PaymentAmount'];
			
			// GET REMAINING BALANC
			$balance = $this->db->get_where('loan', array('id'=>$loan_history['LoanId']))->row()->LoanBalance;			
			$balance = (float)$balance;
			

			
			// ADD THE MONEY BACK TO THE REMAINING BALANCE
			$new_balance = $balance + $payment;

					//var_dump($balance);
			$data = array(
				'LoanBalance' => $new_balance,
				);
			
					//var_dump($data);
			
			
			
			
			// UPDATE MAIN LOAN TABLE TO ADD THE VALUE BACK TO IT
			$this->db->where('id',$loan_history['LoanId']);
			$upd = $this->db->update('loan', $data);
			
			
			if($upd) {
			// REMOVE PAYMENT
            $this->Loan_history_model->delete_loan_history($id);	
			}	
			
            redirect('loan_history/index');
			
        }
        else
            show_error('The loan_history you are trying to delete does not exist.');
    }
    
}
