<?php

class Loan extends MY_Controller{
	
    function __construct()
    {
        parent::__construct();
			$this->isNotLoggedIn();
        $this->load->model('Loan_model');
		
    } 

    /*
     * Listing of loan
     */
    function index()
    {
        $data['loan'] = $this->Loan_model->get_all_loan();
		$data['title'] = 'Loan';
		
        $this->load->view('templates/header', $data);
        $this->load->view('loan/index', $data);
		$this->load->view('templates/footer', $data);
    }

    /*
     * Adding a new loan
     */
    function add()
    {   
        $this->load->library('form_validation');

		$this->form_validation->set_rules('LoanDate','LoanDate','required');
		$this->form_validation->set_rules('LoanWorker','LoanWorker','required|integer');
		$this->form_validation->set_rules('LoanPrinciple','LoanPrinciple','required|numeric');
		$this->form_validation->set_rules('LoanInterest','LoanInterest','required|numeric');
		$this->form_validation->set_rules('LoanRepaymentEvery','LoanRepaymentEvery','required');
		$this->form_validation->set_rules('LoanPeriod','LoanPeriod','required');
		$this->form_validation->set_rules('LoanBalance','LoanBalance','numeric');
		
	
		if($this->form_validation->run())     
        {   
		
			$repayment = (($this->input->post('LoanPrinciple') / 100) * $this->input->post('LoanInterest')) + $this->input->post('LoanPrinciple');
			
            $params = array(
				'LoanWorker' => $this->input->post('LoanWorker'),
				'LoanDate' => $this->input->post('LoanDate'),
				'LoanPrinciple' => $this->input->post('LoanPrinciple'),
				'LoanInterest' => $this->input->post('LoanInterest'),
				'LoanRepaymentEvery' => $this->input->post('LoanRepaymentEvery'),
				'LoanPeriod' => $this->input->post('LoanPeriod'),
				'LoanRepaymentAmount' => $repayment,
				'LoanBalance' => $repayment,
            );
            
            $loan_id = $this->Loan_model->add_loan($params);
            redirect('loan/index');
        }
        else
        {
			$this->load->model('User_model');
			$data['all_users'] = $this->User_model->get_all_users();
			
			$this->load->model('Settings_loan_model');
			$data['get_all_settings_loan'] = $this->Settings_loan_model->get_all_settings_loan();
            $data['title'] = 'Loan';
			
        $this->load->view('templates/header', $data);
        $this->load->view('loan/add', $data);
		$this->load->view('templates/footer', $data);
        }
    }  
	
	//LOAN FOR INDIVIDUAL
	   function giveloan()
    {   


		$this->load->library('form_validation');

		$this->form_validation->set_rules('LoanDate','LoanDate','required');
		$this->form_validation->set_rules('LoanWorker','LoanWorker','required|integer');
		$this->form_validation->set_rules('LoanPrinciple','LoanPrinciple','required|numeric');
		$this->form_validation->set_rules('LoanInterest','LoanInterest','required|numeric');
		$this->form_validation->set_rules('LoanRepaymentEvery','LoanRepaymentEvery','required');
		$this->form_validation->set_rules('LoanPeriod','LoanPeriod','required');
		$this->form_validation->set_rules('LoanType','LoanType','required');
		$this->form_validation->set_rules('LoanBalance','LoanBalance','numeric');
		
		
		if($this->form_validation->run())     
        {  
			
			$repayment = (($this->input->post('LoanPrinciple') / 100) * $this->input->post('LoanInterest')) + $this->input->post('LoanPrinciple');
			
            $params = array(
				'LoanWorker' => $this->input->post('LoanWorker'),
				'LoanDate' => $this->input->post('LoanDate'),
				'LoanPrinciple' => $this->input->post('LoanPrinciple'),
				'LoanInterest' => $this->input->post('LoanInterest'),
				'LoanRepaymentEvery' => $this->input->post('LoanRepaymentEvery'),
				'LoanPeriod' => $this->input->post('LoanPeriod'),
				'LoanRepaymentAmount' => $repayment,
				'LoanBalance' => $repayment,
            );
            
            $loan_id = $this->Loan_model->add_loan($params);
            redirect('loan/index');
        }
        else
        {
			$this->load->model('User_model');
			$data['all_users'] = $this->User_model->get_all_users();
            
			$this->load->model('Settings_loan_model');
			$data['get_all_settings_loan'] = $this->Settings_loan_model->get_all_settings_loan();
			$data['title'] = 'Loan';
			
        $this->load->view('templates/header', $data);
        $this->load->view('loan/giveloan', $data);
		$this->load->view('templates/footer', $data);
        }
    }  
	

    /*
     * Editing a loan
     */
    function edit($id)
    {   
        // check if the loan exists before trying to edit it
        $data['loan'] = $this->Loan_model->get_loan($id);
        
        if(isset($data['loan']['id']))
        {
            $this->load->library('form_validation');

			$this->form_validation->set_rules('LoanDate','LoanDate','required');
			$this->form_validation->set_rules('LoanWorker','LoanWorker','required|integer');
			$this->form_validation->set_rules('LoanPrinciple','LoanPrinciple','required|numeric');
			$this->form_validation->set_rules('LoanInterest','LoanInterest','required|numeric');
			$this->form_validation->set_rules('LoanRepaymentEvery','LoanRepaymentEvery','required');
			$this->form_validation->set_rules('LoanPeriod','LoanPeriod','required');
			$this->form_validation->set_rules('LoanBalance','LoanBalance','numeric');
		
			if($this->form_validation->run())     
            {   
                $params = array(
					'LoanWorker' => $this->input->post('LoanWorker'),
					'LoanDate' => $this->input->post('LoanDate'),
					'LoanPrinciple' => $this->input->post('LoanPrinciple'),
					'LoanInterest' => $this->input->post('LoanInterest'),
					'LoanRepaymentEvery' => $this->input->post('LoanRepaymentEvery'),
					'LoanPeriod' => $this->input->post('LoanPeriod'),
					'LoanRepaymentAmount' => $this->input->post('LoanRepaymentAmount'),
					'LoanBalance' => $this->input->post('LoanBalance'),
                );

                $this->Loan_model->update_loan($id,$params);            
                redirect('loan/index');
            }
            else
            {
				$this->load->model('User_model');
				$data['all_users'] = $this->User_model->get_all_users();
				
				$this->load->model('Settings_loan_model');
				$data['get_all_settings_loan'] = $this->Settings_loan_model->get_all_settings_loan();

				$data['title'] = 'Loan';
        $this->load->view('templates/header', $data);
        $this->load->view('loan/edit', $data);
		$this->load->view('templates/footer', $data);
            }
        }
        else
            show_error('The loan you are trying to edit does not exist.');
    } 

    /*
     * Deleting loan
     */
    function remove($id)
    {
        $loan = $this->Loan_model->get_loan($id);

        // check if the loan exists before trying to delete it
        if(isset($loan['id']))
        {
            $this->Loan_model->delete_loan($id);
            redirect('loan/index');
        }
        else
            show_error('The loan you are trying to delete does not exist.');
    }
    
}
