<?php

class Graph extends MY_Controller 
 {
     public function __construct() {
        parent::__construct();

         $this->isNotLoggedIn();
         $this->load->helper('url_helper');

        $this->load->library('form_validation');
     }
     


     /***
      * summary Income by Class
      */
     public function summary_income_cls()
     {
        
        $date_from = $this->input->get('date_from') ? $this->input->get('date_from') : '2018-06-01' ;
        $date_to = $this->input->get('date_to') ? $this->input->get('date_to') : date('Y-m-d') ;
   
   
        $sql = "SELECT sum(t1.paid_amount) `amount`, t2.class_name `class` 
        from payment_history t1
        JOIN class t2
        on t2.class_id = t1.class_id
        WHERE t1.payment_date BETWEEN '$date_from' AND '$date_to' 
        GROUP BY t2.class_name asc";
   
       $result = $this->db->query($sql,array('%'.$date_from,'%'.$date_to))->result_array();
      
   
        foreach($result as $row){
            $amount[] = $row['amount'];
            // $dates[] = date('M Y', strtotime($row['date']));
            $class[] = $row['class'];
        }
   
       
   
          
   
        $data['result'] = $result;
        $data['amount'] = $amount;
        $data['class'] = $class;
        $data['sql'] = $sql;
        $data['title'] = 'Summary Income by Class';
        $data['control_name'] = 'Summary Income by Class';
        $this->load->view('templates/header',$data);
        $this->load->view('graphs/summary_income_cls');
        $this->load->view('templates/footer',$data);
     }



     /**
      * Summary income by cash type
      */

     public function summary_income_cashType()
     {
         # code...
         $date_from = $this->input->get('date_from') ? $this->input->get('date_from') : '2018-06-01' ;
         $date_to = $this->input->get('date_to') ? $this->input->get('date_to') : date('Y-m-d') ;
    
    
         $sql = "SELECT sum(t1.paid_amount) `amount`, t2.class_name `class` ,t1.payment_method `pay_meth`
         from payment_history t1
         JOIN class t2
         on t2.class_id = t1.class_id
         WHERE t1.payment_date BETWEEN '$date_from' AND '$date_to' 
         GROUP BY t1.payment_method asc";
    
        $result = $this->db->query($sql,array('%'.$date_from,'%'.$date_to))->result_array();
       
    
         foreach($result as $row){
             $amount[] = $row['amount'];
             // $dates[] = date('M Y', strtotime($row['date']));
             $class[] = $row['pay_meth'];
         }
    
        
    
           
    
         $data['result'] = $result;
         $data['amount'] = $amount;
         $data['class'] = $class;
         $data['sql'] = $sql;
         $data['title'] = 'Summary Income by CashType';
         $data['control_name'] = 'Summary Income by CashType';
         $this->load->view('templates/header',$data);
         $this->load->view('graphs/summary_income_cashType');
         $this->load->view('templates/footer',$data);
     }


    /**
     * 
     * Weekly Net Income
     */

     public function net_income_weekly()
     {
           
            $date_from = $this->input->get('date_from') ? $this->input->get('date_from') : '2018-06-01' ;
            $date_to = $this->input->get('date_to') ? $this->input->get('date_to') : date('Y-m-d') ;


            $sql_exp = "SELECT `date` as `date` ,sum(total_amount) expenses from expenses_name WHERE `date` BETWEEN '$date_from' and '$date_to' GROUP BY yearweek(`date`) asc";

            $sql_inc = "SELECT  DATE_ADD(`payment_date`,INTERVAL(1-DAYOFWEEK(`payment_date`))DAY)  `start_date`, DATE_ADD(`payment_date`,INTERVAL(7-DAYOFWEEK(`payment_date`))DAY)  `end_date`, sum(paying_amount) income from payment_history WHERE `payment_date` BETWEEN '$date_from' and '$date_to' GROUP BY yearweek(`payment_date`) asc";

            $result = $this->db->query($sql_exp,array('%'.$date_from,'%'.$date_to))->result_array();
            $result_inc = $this->db->query($sql_inc,array('%'.$date_from,'%'.$date_to))->result_array();

            if (count($result) > count($result_inc)) {
                $count = count($result);
            }else{
            $count = count($result_inc);
            }
            $i= 0;
            $net = array();

            while ($i < $count) {
                if(empty($result[$i]['expenses'])) {
                    (float)$result[$i]['expenses'] = 0;
                }

                if(empty($result[$i]['income'])) {
                    (float)$result[$i]['income'] = 0;
                }


                $net[] = ['date' => date('d M',strtotime($result_inc[$i]['start_date'])).' - '.date('d M',strtotime($result_inc[$i]['end_date'])) , 'net'=>(float)$result_inc[$i]['income'] - (float)$result[$i]['expenses'] ];                            
            $i++; 
            }
            
            // var_dump($net);

            foreach($net as $row){
                $n[] = $row['net'];               
                $date_final[] = $row['date'];
            }


            $data['result'] = $result;
            $data['dates'] = $date_final;
            $data['net'] = $n;
            $data['title'] = 'NET Income by Week';
            $data['control_name'] = 'NET Income by Week';
            $this->load->view('templates/header',$data);
            $this->load->view('graphs/net_income_week');
            $this->load->view('templates/footer',$data);
     }


     /**
      * Monthly Net Income
      */


      public function net_income_monthly(Type $var = null)
      {

          $date_from = $this->input->get('date_from') ? $this->input->get('date_from') : '2018-06-01' ;
          $date_to = $this->input->get('date_to') ? $this->input->get('date_to') : date('Y-m-d') ;
     
          
          $sql_exp = "SELECT `date` as `date` ,sum(total_amount) expenses from expenses_name WHERE `date` BETWEEN '$date_from' and '$date_to' GROUP BY month(`date`) asc";

          $sql_inc = "SELECT payment_date `date`, sum(paying_amount) income from payment_history WHERE `payment_date` BETWEEN '$date_from' and '$date_to' GROUP BY month(`payment_date`) asc";

          $result = $this->db->query($sql_exp,array('%'.$date_from,'%'.$date_to))->result_array();
          $result_inc = $this->db->query($sql_inc,array('%'.$date_from,'%'.$date_to))->result_array();


          if (count($result) > count($result_inc)) {
            $count = count($result);
        }else{
        $count = count($result_inc);
        }
        $i= 0;
        $net = array();

        while ($i < $count) {
            if(empty($result[$i]['expenses'])) {
                (float)$result[$i]['expenses'] = 0;
            }

            if(empty($result[$i]['income'])) {
                (float)$result[$i]['income'] = 0;
            }

             $net[] = ['date' => date('d M',strtotime($result_inc[$i]['date'])), 'net'=>(float)$result_inc[$i]['income'] - (float)$result[$i]['expenses'] ];                            
        $i++; 
        }
     
        
        
         foreach($net as $row){
            $n[] = $row['net'];               
            $date_final[] = $row['date'];
        }
     
          foreach($result as $row){
              $expenses[] = $row['expenses'];
              
          }
     
         
     
            // var_dump($net);
     
          $data['result'] = $result;
          $data['dates'] = $date_final;
        //   $data['income'] = $;
          $data['amount'] = $n;
          $data['expenses'] = $expenses;
          $data['title'] = 'NET Income by Month';
          $data['control_name'] = 'NET Income by Month';
          $this->load->view('templates/header',$data);
          $this->load->view('graphs/net_income_month');
          $this->load->view('templates/footer',$data);
      }
 }
 

?>